/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: CanDl_Functionlist.h $
   Last Modification:
    $Author: Mirko $
    $Modtime: 10.04.06 12:47 $
    $Revision: 4 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Can Dl
    Task function list for configuration file
       
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
#ifndef __CAN_DL_FUNCTIONLIST_H
#define __CAN_DL_FUNCTIONLIST_H



/***************************************************************************************/
/* Can Dl function list, prototyes */

TLR_VOID  TaskExit_CanDl(TLR_VOID FAR* pvRsc);
TLR_RESULT  TaskLeave_CanDl(TLR_VOID FAR* pvRsc,TLR_VOID FAR* pvLve);                                             
TLR_VOID  TaskEnter_CanDl(TLR_VOID FAR* pvInit);



#define CAN_DL_STARTUP_PARAM_VERSION_2 (2)

#define CAN_DL_PRM_AUTO_START         0x00000001
#define CAN_DL_PRM_ENABLE_MODE        0x00000002
#define CAN_DL_PRM_ENABLE_BAUDRATE    0x00000004
#define CAN_DL_PRM_ENABLE_TX_TIMEOUT  0x00000008
#define CAN_DL_PRM_ENABLE_RXIDS       0x00000010
#define CAN_DL_PRM_ENABLE_FILTER_0    0x00000020
#define CAN_DL_PRM_ENABLE_FILTER_1    0x00000040
#define CAN_DL_PRM_ENABLE_EVENTS      0x00000080



typedef struct CAN_DL_STARTUP_PARAM_Ttag
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;
  
  /* Driver Layer config paramter */
  TLR_STR              *pszNameFifoUnit;
  TLR_UINT32           ulFifoInstance;
  TLR_STR              *pszNameXPEC;
  TLR_UINT32           ulXPECInstance;
  TLR_STR              *pszNameXMACRPU;
  TLR_UINT32           ulXMACRPUInstance;
  TLR_STR              *pszNameXMACTPU;
  TLR_UINT32           ulXMACTPUInstance;
  TLR_STR              *pszNameComIrq;
  TLR_UINT32           ulComIrqInstance;
  
  /* Task Layer config parameter */   
  TLR_UINT32           ulSizeRxBuffer;
  TLR_UINT32           ulQueueSize;
  TLR_UINT32           ulEnableBits;
  TLR_UINT32           ulMode;  
  TLR_UINT32           ulBaudrate;
  TLR_UINT32           ulTxAbortTime;
  TLR_UINT32           ulEventsToIndicate;  
  TLR_UINT32           ulFilter0AcceptanceCode;
  TLR_UINT32           ulFilter0AcceptanceMask;
  TLR_UINT32           ulFilter1AcceptanceCode;
  TLR_UINT32           ulFilter1AcceptanceMask;    
  TLR_UINT32           ulRxIdStart;
  TLR_UINT32           ulRxIdEnd;
  TLR_UINT32           ulPoolSize;

} CAN_DL_STARTUP_PARAM_T;


/*
************************************************************
*   XC Configuration
************************************************************
*/
/* External references to the XC codings */

#ifndef XC_CODE_CAN_XPEC0
    extern UINT32 XcCode_xpec_can0;
    #define XC_CODE_CAN_XPEC0 ((UINT32 FAR*)&XcCode_xpec_can0)
#endif
#ifndef  XC_CODE_CAN_XPEC1
    extern UINT32 XcCode_xpec_can1;
    #define XC_CODE_CAN_XPEC1 ((UINT32 FAR*)&XcCode_xpec_can1)
#endif
#ifndef  XC_CODE_CAN_XPEC2
  extern UINT32 XcCode_xpec_can2;
  #define XC_CODE_CAN_XPEC2 ((UINT32 FAR*)&XcCode_xpec_can2)
#endif
#ifndef  XC_CODE_CAN_XPEC3
  extern UINT32 XcCode_xpec_can3;
  #define XC_CODE_CAN_XPEC3 ((UINT32 FAR*)&XcCode_xpec_can3)
#endif

#ifndef XC_CODE_CAN_RPEC0
  extern UINT32 XcCode_xpec_can_rpec0;
  #define XC_CODE_CAN_RPEC0 ((UINT32 FAR*)&XcCode_xpec_can_rpec0)
#endif
#ifndef XC_CODE_CAN_RPEC1
  extern UINT32 XcCode_xpec_can_rpec1;
  #define XC_CODE_CAN_RPEC1 ((UINT32 FAR*)&XcCode_xpec_can_rpec1)
#endif

#ifndef  XC_CODE_CAN_RPU0
  extern UINT32 XcCode_rpu_can0;
  #define XC_CODE_CAN_RPU0 ((UINT32 FAR*)&XcCode_rpu_can0)
#endif
  #ifndef  XC_CODE_CAN_RPU1
  extern UINT32 XcCode_rpu_can1;
#define XC_CODE_CAN_RPU1 ((UINT32 FAR*)&XcCode_rpu_can1)
#endif
#ifndef  XC_CODE_CAN_RPU2
  extern UINT32 XcCode_rpu_can2;
  #define XC_CODE_CAN_RPU2 ((UINT32 FAR*)&XcCode_rpu_can2)
#endif
#ifndef  XC_CODE_CAN_RPU3
  extern UINT32 XcCode_rpu_can3;
  #define XC_CODE_CAN_RPU3 ((UINT32 FAR*)&XcCode_rpu_can3)
#endif

#ifndef  XC_CODE_CAN_TPU0
  extern UINT32 XcCode_tpu_can0;
  #define XC_CODE_CAN_TPU0 ((UINT32 FAR*)&XcCode_tpu_can0)
#endif
#ifndef  XC_CODE_CAN_TPU1
  extern UINT32 XcCode_tpu_can1;
  #define XC_CODE_CAN_TPU1 ((UINT32 FAR*)&XcCode_tpu_can1)
#endif
#ifndef  XC_CODE_CAN_TPU2
  extern UINT32 XcCode_tpu_can2;
  #define XC_CODE_CAN_TPU2 ((UINT32 FAR*)&XcCode_tpu_can2)
#endif
#ifndef  XC_CODE_CAN_TPU3
  extern UINT32 XcCode_tpu_can3;
  #define XC_CODE_CAN_TPU3 ((UINT32 FAR*)&XcCode_tpu_can3)
#endif


/***************************************************************************************/
#endif /* #ifndef __CAN_DL_FUNCTIONLIST_H */
